<?LassoScript
	
	// Store the inputs to the page in variables.  The inputs include the 'section'
	// and 'page' which should be shown to the site visitor.  The 'mode' which can be
	// set to 'edit' in order to show the administration interface.  And, the 'action'
	// which is used within the administration interface on each submitted form.
	
	var: 'section' = (action_param: 'section', (action_param: 'section', -count));
	var: 'page' = (action_param: 'page', (action_param: 'page', -count));
	var: 'mode' = (action_param: 'mode', (action_param: 'mode', -count));
	var: 'action' = (action_param: 'action', (action_param: 'action', -count));
	
	// The variable 'handled' is set to true by one of the invidividual solution pages
	// when it has successfully handled the current request.  If none of the administration
	// pages handle the request then the page is shown using 'template.lasso' to the site
	// visitor.
	
	var: 'handled' = false;

	// Only an administrator or a member of the group 'OP Collaborate Admins' can access the
	// edit interface.  If the mode is 'edit' we prompt for their username and password.

	if: ($mode == 'edit');
		var: 'url' = 'index.lasso';
		var: 'params' = (array: 'mode=edit');
		if: $section != '';
			$params->(insert: 'section=' + (encode_stricturl: $section));
		/if;
		if: $page != '';
			$params->(insert: 'page=' + (encode_stricturl: $page));
		/if;
		if: $params->size > 0;
			$url += '?' + $params->(join: '&');
		/if;
		redirect_url: $url;
	/if;
	
	if: ($handled == false);

		// Display the site to a site visitor.  If none of the administration pages are
		// being shown then the site must actually be served.  This is accomplished by
		// finding the records for the preferences, section, and current page,
		// assembling a set of variables with values from those records, and then using
		// 'template.lasso' to generate the page for the visitor.
		//
		// The current section and page are passed in two action parameters 'section'
		// and 'page. This code handles four different scenarios.  If neither parameter
		// is specified then the default section is assumed.  If a page is specified
		// but not section then the section for the page is looked up.  If no page is
		// specified then the default page for the current section is assumed. And, if
		// both a section and page are specified then they are simply returned.
	
		// Default values.  These variables are all required by 'template.lasso'.
		var: 'prefs' = (map);
		var: 'page_body' = '';
		var: 'page_title' = '';
		var: 'section_header' = '';
		var: 'section_footer' = '';
		var: 'section_title' = '';
		var: 'site_title' = '';
		var: 'site_header' = '';
		var: 'site_footer' = '';

		// Look up the global preferences record.  There will always be only one
		// record in the 'prefs' table.  The global preferences define the Site's title,
		// header, and footer.  Also, the global preferences for the site are
		// deserialized from the 'prefs' field and inserted into the 'prefs' variable.

		inline: -log=$log_level,
				-search,
				-database='op_collaborate',
				-table='prefs',
				-keyfield='id',
				-maxrecords=1, -uselimit;
			if: (found_count == 1);
				var: 'site_title' = (field: 'title');
				var: 'site_header' = (field: 'header');
				var: 'site_footer' = (field: 'footer');
				if: (field: 'prefs') >> '<map';
					var: 'temp' = null;
					$temp->(deserialize: (field: 'prefs'));
					$prefs->(insertfrom: $temp->iterator);
				/if;
			/if;
		/inline;

		// These variables track whether the desired page and section have been found.
		var: 'page_done' = false;
		var: 'section_done' = false;
		
		// If the 'section' is not specified, but the 'page' is then we first find the
		// desired page and then use it to find the current section.
		
		if: ($section == '') && ($page != '');
			
			// Find the specified page.
			inline: -log=$log_level,
					-search,
					-database='op_collaborate',
					-table='pages',
					-keyfield='id',
					-op='eq', 'code'=$page,
					-op='eq', 'status'='Y',
					-maxrecords=1, -uselimit;
				if: (found_count == 1);
				
					// If the page was found then we find its section.
					inline: -log=$log_level,
							-search,
							-database='op_collaborate',
							-table='sections',
							-keyfield='id',
							-op='eq', 'id'=(field: 'section_id'),
							-op='eq', 'status'='Y',
							-maxrecords=1, -uselimit;
						if: (found_count == 1);
							
							// If the section was found then we store its values in variables
							// and set 'section_done' to true.
							var: 'section' = (field: 'code');
							var: 'section_id' = (field: 'id');
							var: 'section_header' = (field: 'header');
							var: 'section_footer' = (field: 'footer');
							var: 'section_title' = (field: 'title');
							if: (field: 'prefs') >> '<map';
								var: 'temp' = null;
								$temp->(deserialize: (field: 'prefs'));
								$prefs->(insertfrom: $temp->iterator);
							/if;
							var: 'section_done' = true;
						/if;
					/inline;
					
					// If the section was found then we also store the page's values in variables
					// and set 'page_done' to true.  Otherwise, we reset 'section' and 'page' to
					// empty so defaults will be used.
					if: $section_done == true;
						var: 'page_body' = (field: 'body');
						var: 'page_title' = (field: 'title');
						if: (field: 'prefs') >> '<map';
							var: 'temp' = null;
							$temp->(deserialize: (field: 'prefs'));
							$prefs->(insertfrom: $temp->iterator);
						/if;
						var: 'page_done' = true;
					else;
						var: 'section' = '';
						var: 'page' = '';
					/if;
				/if;
			/inline;
		/if;

		// If the section has not been found and the 'section' action parameters is not empty
		// then we search for the specified section.
		
		if: ($section_done == false) && ($section != '');
			inline: -log=$log_level,
					-search,
					-database='op_collaborate',
					-table='sections',
					-keyfield='id',
					-op='eq', 'code'=$section,
					-op='eq', 'status'='Y',
					-maxrecords=1, -uselimit;
				if: (found_count == 1);
				
					// If the section was found then we store its values in variables
					// and set 'section_done' to true.
					var: 'section_id' = (field: 'id');
					var: 'section_header' = (field: 'header');
					var: 'section_footer' = (field: 'footer');
					var: 'section_title' = (field: 'title');
					if: (field: 'prefs') >> '<map';
						var: 'temp' = null;
						$temp->(deserialize: (field: 'prefs'));
						$prefs->(insertfrom: $temp->iterator);
					/if;
					var: 'section_done' = true;
				else;
					var: 'section' = '';
				/if;
			/inline;
		/if;
		
		// If the section has not yet been found then we find the first section.  This means
		// that if a visitor comes to the site without specifying a section or if they specify
		// an invalid section or page then the default (first) section will be shown to them.
		
		if: ($section_done == false);
			inline: -log=$log_level,
					-search,
					-database='op_collaborate',
					-table='sections',
					-keyfield='id',
					-op='eq', 'status'='Y',
					-sortfield='sort',
					-maxrecords=1, -uselimit;
				if: (found_count == 1);

					// If the section was found then we store its values in variables
					// and set 'section_done' to true.
					var: 'section' = (field: 'code');
					var: 'section_id' = (field: 'id');
					var: 'section_header' = (field: 'header');
					var: 'section_footer' = (field: 'footer');
					var: 'section_title' = (field: 'title');
					if: (field: 'prefs') >> '<map';
						var: 'temp' = null;
						$temp->(deserialize: (field: 'prefs'));
						$prefs->(insertfrom: $temp->iterator);
					/if;
					var: 'section_done' = true;
				else;
					var: 'section' = '';
				/if;
			/inline;
		/if;
		
		// If the section has still not been found then we return an error.  This means that
		// there are no valid sections defined on the site.
		
		if: ($section_done == false);
			error_code = -1;
			error_msg = 'No Valid Sections Found';
		else;
		
		// If the page has not been found and the 'page' action parameters is not empty
		// then we search for the specified page in the current section.  Note that if the
		// specified page and section don't match then the section will be found first, but
		// the page will not.  The default page for the section will be used instead.
			
			if: ($page_done == false) && ($page != '');
				inline: -log=$log_level,
						-search,
						-database='op_collaborate',
						-table='pages',
						-keyfield='id',
						-op='eq', 'code'=$page,
						-op='eq', 'section_id'=$section_id,
						-op='eq', 'status'='Y',
						-maxrecords=1, -uselimit;
					if: (found_count == 1);

						// If the page was found then we store its values in variables
						// and set 'page_onde' to true.
						var: 'page_body' = (field: 'body');
						var: 'page_title' = (field: 'title');
						if: (field: 'prefs') >> '<map';
							var: 'temp' = null;
							$temp->(deserialize: (field: 'prefs'));
							$prefs->(insertfrom: $temp->iterator);
						/if;
						var: 'page_done' = true;
					else;
						var: 'page' = '';
					/if;
				/inline;
			/if;

			// If the page has not yet been found then we find the first page in the current
			// section.
			
			if: ($page_done == false);
				inline: -log=$log_level,
						-search,
						-database='op_collaborate',
						-table='pages',
						-keyfield='id',
						-op='eq', 'section_id'=$section_id,
						-op='eq', 'status'='Y',
						-maxrecords=1, -uselimit,
						-sortfield='sort';
					if: (found_count == 1);

						// If the page was found then we store its values in variables
						// and set 'page_onde' to true.
						var: 'page' = (field: 'code');
						var: 'page_body' = (field: 'body');
						var: 'page_title' = (field: 'title');
						if: (field: 'prefs') >> '<map';
							var: 'temp' = null;
							$temp->(deserialize: (field: 'prefs'));
							$prefs->(insertfrom: $temp->iterator);
						/if;
						var: 'page_done' = true;
					else;
						var: 'page' = '';
					/if;
				/inline;
			/if;

			// If the page has still not been found then we return an error.  This means that
			// there are no valid pages defined in the section.
			
			if: ($page_done == false);
				error_code = -1;
				error_msg = 'No Valid Pages Found';
			/if;
		/if;
		
		// Generate the title for the page.
		
		var: 'array' = (array);
		if: (var: 'page_title') != '';
			$array->(insert: $page_title);
		/if;
		if: (var: 'section_title') != '';
			$array->(insert: $section_title);
		/if;
		if: (var: 'site_title') != '';
			$array->(insert: $site_title);
		/if;
		if: $array->size == 0;
			var: 'title' = 'Collaborate';
		else;
			var: 'title' = $array->(join: ' - ');
		/if;
					
	/if;
?>
